IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Browse_Productos_Precios_Elegir]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Browse_Productos_Precios_Elegir] 
END
GO

CREATE PROCEDURE [dbo].[CP_Browse_Productos_Precios_Elegir] @pId_Cliente		INT
AS
BEGIN

DECLARE @sqlStr						NVARCHAR(4000)
DECLARE @Id_Lista_Precio			SMALLINT
DECLARE @Id_Lista_Precio_Especial	SMALLINT --Agregada el 06/02/2019 por Pedido de Cirugia

CREATE TABLE #BrowseProductosPreciosElegir (Codigo					VARCHAR(14),
											Descripcion_Producto	VARCHAR(150),
											Precio_Sin_Iva			DECIMAL(13,4),
											Precio_Con_Iva			DECIMAL(13,4),
											Stock_Fisico			DECIMAL(19,4),
											Stock_Pedido			DECIMAL(19,4), 
											Stock_Orden_Compra		DECIMAL(19,4),
											Familia					VARCHAR(35),
											Codigo_Externo			VARCHAR(40),
											Descripcion_Reducida	VARCHAR(100),
											Presentacion_Codigo		VARCHAR(10),
											Presentacion_Descripcion VARCHAR(50),
											Foto_Grande				VARCHAR(255),
											Cantidad				DECIMAL(13,4),
											Cod_Barra				VARCHAR(255)
											)

SET @Id_Lista_Precio			= ISNULL((SELECT ISNULL(Id_Lista_Precio, 0) FROM Clientes WHERE Id_Cliente = @pId_Cliente), 0)
SET @Id_Lista_Precio_Especial	= ISNULL((SELECT ISNULL(Id_Precio_Especial, 0) FROM Clientes WHERE Id_Cliente = @pId_Cliente), 0)

IF(@Id_Lista_Precio = 0)
BEGIN
	SET @sqlStr =	N'SELECT '+
					'PR.Id_Producto AS Codigo, '+
					'PR.Descripcion_Detallada AS Descripcion_Producto, '+
					'PR.Precio_Gravado AS Precio_Sin_Iva, '+
					'PR.Precio_Final AS Precio_Con_Iva, '+
					'dbo.CF_Prod_Stock(PR.Id_Producto, GETDATE()) AS Stock_Fisico, '+
					'0 AS Stock_Pedido, '+
					'0 AS Stock_Orden_Compra, '+
					'PF.Descripcion AS Familia, '+
					'PR.Id_Producto_Externo AS Codigo_Externo, '+
					'PR.Descripcion_Resumida AS Descripcion_Reducida, '+
					'PR.Id_Present AS Presentacion_Codigo, '+
					'PP.Descripcion AS Presentacion_Descripcion, '+
					'PR.Foto_Grande AS Foto_Grande, '+
					'PR.Cantidad AS Cantidad, '+
					'CB.Cod_Barra '+
					'FROM Productos PR, Prod_Familias PF, Prod_Present PP, Productos_CBarras CB '+
					'WHERE '+
					'ISNULL(PR.Id_Familia, 0) = PF.Id_Familia '+
					'AND ISNULL(PR.Id_Present, '''') = PP.Id_Present '+
					'AND PR.Id_Producto <> '''' '+
					'AND PR.Activo = 1 '+
					'AND CB.Id_Producto=PR.Id_Producto '+
					'ORDER BY PR.Descripcion_Detallada'
END
ELSE
BEGIN
	IF(@Id_Lista_Precio_Especial = 0)
	BEGIN
		SET @sqlStr =	N'SELECT '+
						'PR.Id_Producto AS Codigo, '+
						'PR.Descripcion_Detallada AS Descripcion_Producto, '+
						'PLPI.Precio AS Precio_Sin_Iva, '+
						'(PLPI.Precio * (1 + (PT.Porc1/100))) AS Precio_Con_Iva, '+
						'dbo.CF_Prod_Stock(PR.Id_Producto, GETDATE()) AS Stock_Fisico, '+
						'0 AS Stock_Pedido, '+
						'0 AS Stock_Orden_Compra, '+
						'PF.Descripcion AS Familia, '+
						'PR.Id_Producto_Externo AS Codigo_Externo, '+
						'PR.Descripcion_Resumida AS Descripcion_Reducida, '+
						'PR.Id_Present AS Presentacion_Codigo, '+
						'PP.Descripcion AS Presentacion_Descripcion, '+
						'PR.Foto_Grande AS Foto_Grande, '+
						'PR.Cantidad AS Cantidad, '+
						'CB.Cod_Barra '+
						'FROM Productos PR, Prod_Familias PF, Prod_Present PP, Prod_Listas_Precios_Items PLPI, Productos_TasaIva PT, Productos_CBarras CB '+
						'WHERE '+
						'ISNULL(PR.Id_Familia, 0) = PF.Id_Familia '+
						'AND PR.Id_Producto = PLPI.Id_Producto '+
						'AND PR.Id_Iva = PT.Id_Iva '+
						'AND ISNULL(PR.Id_Present, '''') = PP.Id_Present '+
						'AND PR.Id_Producto <> '''' '+
						'AND PR.Activo = 1 '+
						'AND CB.Id_Producto=PR.Id_Producto '+
						'AND PLPI.Id_Lista_Precio = '+ CONVERT(VARCHAR(10), @Id_Lista_Precio) + ' ' +
						'ORDER BY PR.Descripcion_Detallada'
	END
	ELSE
	BEGIN
		SET @sqlStr =	N'SELECT '+
						'PR.Id_Producto AS Codigo, '+
						'PR.Descripcion_Detallada AS Descripcion_Producto, '+
						'PLPI.Precio AS Precio_Sin_Iva, '+
						'(PLPI.Precio * (1 + (PT.Porc1/100))) AS Precio_Con_Iva, '+
						'dbo.CF_Prod_Stock(PR.Id_Producto, GETDATE()) AS Stock_Fisico, '+
						'0 AS Stock_Pedido, '+
						'0 AS Stock_Orden_Compra, '+
						'PF.Descripcion AS Familia, '+
						'PR.Id_Producto_Externo AS Codigo_Externo, '+
						'PR.Descripcion_Resumida AS Descripcion_Reducida, '+
						'PR.Id_Present AS Presentacion_Codigo, '+
						'PP.Descripcion AS Presentacion_Descripcion, '+
						'PR.Foto_Grande AS Foto_Grande, '+
						'PR.Cantidad AS Cantidad, '+
						'CB.Cod_Barra '+
						'FROM Productos PR, Prod_Familias PF, Prod_Present PP, Prod_Listas_Precios_Items PLPI, Productos_TasaIva PT, Productos_CBarras CB '+
						'WHERE '+
						'ISNULL(PR.Id_Familia, 0) = PF.Id_Familia '+
						'AND PR.Id_Producto = PLPI.Id_Producto '+
						'AND PR.Id_Iva = PT.Id_Iva '+
						'AND ISNULL(PR.Id_Present, '''') = PP.Id_Present '+
						'AND PR.Id_Producto <> '''' '+
						'AND PR.Activo = 1 '+
						'AND CB.Id_Producto=PR.Id_Producto '+
						'AND PLPI.Id_Lista_Precio IN ('+ CONVERT(VARCHAR(10), @Id_Lista_Precio) + ', ' + CONVERT(VARCHAR(10), @Id_Lista_Precio_Especial) + ') ' +
						'ORDER BY PR.Descripcion_Detallada'
	END
END

INSERT INTO #BrowseProductosPreciosElegir
EXECUTE sp_executesql @sqlStr


SELECT * FROM #BrowseProductosPreciosElegir

DROP TABLE #BrowseProductosPreciosElegir

END
